<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Transaction extends Model 
{

    protected $table = 'transactions';
    public $timestamps = true;
    protected $fillable = array('transaction_item_id', 'safe_id', 'notes', 'type', 'amount');

    public function safe()
    {
        return $this->belongsTo('App\Models\Safe');
    }

    public function transactionItem()
    {
        return $this->belongsTo('App\Models\TransactionItem');
    }

}